// Minimal Content Script: CDP bridge only (pairing + WSS). No plan execution.

// Trusted web origins that are allowed to talk to the extension.
// IMPORTANT: we do NOT accept messages from arbitrary sites, only from these domains.
const ALLOWED_ORIGINS = [
  'https://snegikom.ru',
  'https://app.snegikom.ru',
  'http://localhost:3000',
].filter(Boolean);

let APP_ORIGIN = null; // set on first accepted message

// Persistent connection to background
const bgPort = chrome.runtime.connect({ name: 'snegikom_bridge' });

// Bridge WS to Engine (started after SNEGIKOM_PAIR)
// origin: fixed engine origin, configured from extension side (not from the web page)
let BRIDGE = { ws: null, token: null, origin: null };
const DEV = (location.hostname === 'localhost');
function wsUrlFromOrigin(origin){ return origin.replace(/^http/i, 'ws'); }
function wsSend(obj){ try { BRIDGE.ws?.readyState===WebSocket.OPEN && BRIDGE.ws.send(JSON.stringify(obj)); } catch {}
}

function startBridgeWs(){
  if (!BRIDGE.token || !BRIDGE.origin) return;
  const url = `${wsUrlFromOrigin(BRIDGE.origin)}/local-bridge/socket?token=${encodeURIComponent(BRIDGE.token)}`;
  try{
    BRIDGE.ws = new WebSocket(url);
    BRIDGE.ws.onopen = ()=>{ try { wsSend({ type:'hello', agent:'chrome-content', version:'1.1.0' }); } catch {} };
    BRIDGE.ws.onmessage = (ev)=>{
      try{
        const msg = JSON.parse(ev.data);
        // Forward CDP commands to background (chrome.debugger lives there)
        if (msg && (msg.type==='cdp.attach' || msg.type==='cdp.send' || msg.type==='cdp.detach')){
          bgPort.postMessage({ type:'bridge_forward', payload: msg });
        }
      }catch{}
    };
    BRIDGE.ws.onclose = ()=>{ setTimeout(startBridgeWs, 1500); };
    BRIDGE.ws.onerror = ()=>{ try { BRIDGE.ws && BRIDGE.ws.close(); } catch {} };
  }catch{}
}

// Receive responses/events from background and forward to Engine
bgPort.onMessage.addListener((m)=>{ try{ if (m && m.type==='bridge_forward_to_engine' && m.payload){ wsSend(m.payload); } }catch{} });

chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
  if (msg?.type==='ping') { try { sendResponse({ ok: true }); } catch {} return true; }
});

// Page-to-Extension bridge: only pairing and ping/pong; no plan execution
window.addEventListener('message', (ev)=>{
  try {
    // Accept messages ONLY from trusted app origins
    if (!ALLOWED_ORIGINS.includes(ev.origin)) return;
    APP_ORIGIN = ev.origin; // remember app origin
    const data = ev.data;
    if (data && data.type === 'SNEGIKOM_PING'){
      window.postMessage({ type:'SNEGIKOM_PONG', payload:{ ready:true, version:'1.1.0' } }, ev.origin);
    }
    if (data && data.type === 'SNEGIKOM_PAIR' && data.token){
      // We deliberately IGNORE any bridgeOrigin passed from the page.
      // The actual engine origin is configured inside the extension (e.g. via env or options).
      BRIDGE.token = data.token;
      // BRIDGE.origin must be set from extension configuration; if it's not set yet, pairing is deferred.
      startBridgeWs();
      try { chrome.runtime.sendMessage({ type:'pair', token: data.token }); } catch {}
    }
  } catch {}
});
